﻿document.addEventListener("DOMContentLoaded", function () {
  const bar = document.getElementById("cookie-consent-bar");
  const fab = document.getElementById("cookie-consent-fab");

  if (!bar || !fab) return;

  function hideBar() {
    bar.style.display = "none";
    fab.style.display = "flex";
  }

  function showBar() {
    bar.style.display = "flex";
    fab.style.display = "none";
  }

  document
    .getElementById("cookie-consent-accept")
    ?.addEventListener("click", hideBar);

  document
    .getElementById("cookie-consent-decline")
    ?.addEventListener("click", hideBar);

  fab.addEventListener("click", showBar);
});
