﻿  document.addEventListener("DOMContentLoaded", function () {

    function parseShippingValue(value) {
      var parts = String(value || '').split('___');
      return { name: (parts[0] || '').trim(), system: (parts[1] || '').trim() };
    }
  function isGeis(value) {
    return /shipping\.geis/i.test(parseShippingValue(value).system);
  }

  var WIDGET_MODE = 0;
  if (typeof window.geisCheckoutWidgetMode !== 'undefined' && window.geisCheckoutWidgetMode !== null) {
    WIDGET_MODE = Number(window.geisCheckoutWidgetMode);
  } else if (typeof window.GeisCheckoutWidgetMode !== 'undefined' && window.GeisCheckoutWidgetMode !== null) {
    WIDGET_MODE = Number(window.GeisCheckoutWidgetMode);
  }

  var ICON_URL = "";
  if (typeof window.geisIconUrl !== 'undefined' && window.geisIconUrl) {
    ICON_URL = String(window.geisIconUrl);
  } else if (typeof window.GeisIconUrl !== 'undefined' && window.GeisIconUrl) {
    ICON_URL = String(window.GeisIconUrl);
  }

  function ensureBaseStylesInjected() {
    if (document.getElementById('geis-style')) return;
  var style = document.createElement('style');
  style.id = 'geis-style';
  style.textContent =
  '.method-name.geis-with-icon{position:relative;padding-left:56px;}' +
  '.method-name .geis-method-icon-left{position:absolute;left:12px;top:50%;transform:translateY(-50%);width:42px;height:42px;object-fit:contain;pointer-events:none;}';
  document.head.appendChild(style);
  }

  function findTitleContainerFor(radio) {
    var li = radio.closest && radio.closest('li');
    if (li) {
      var nameEl = li.querySelector('.method-name');
    if (nameEl) return nameEl;
    }
    if (radio.id) {
      var lbl = document.querySelector('label[for="' + radio.id + '"]');
    if (lbl) return lbl;
    }
    return li || radio.parentElement;
  }

    function addIconIfNeeded(radio) {
    if (WIDGET_MODE !== 1 || !ICON_URL) return;
    var container = findTitleContainerFor(radio);
    if (!container) return;

    if (!/method-name/.test(container.className)) {
      container.classList.add('method-name');
    }
    container.classList.add('geis-with-icon');

    if (!container.querySelector('.geis-method-icon-left')) {
      var img = new Image();
    img.src = ICON_URL;
    img.alt = 'Geis';
    img.className = 'geis-method-icon-left';
    container.insertAdjacentElement('afterbegin', img);
    }
  }

    function onShippingChange(e) {
    var radio = e.target;
    if (!radio || !radio.checked) return;
    if (isGeis(radio.value)) {
      fetch('/GeisCheckout/SaveShippingAddressAsPickupPoint', { cache: 'no-store' })
        .then(function (r) { return r.ok ? r.json() : null; })
        .then(function (res) { if (res && res.success === false) console.warn('Geis controller returned error:', res); })
        .catch(function (err) { console.error('Geis controller fetch error:', err); });
    }
  }

    function wireRadios(scope) {
    var radios = (scope || document).querySelectorAll('input[type="radio"][name="shippingoption"]');
    Array.prototype.forEach.call(radios, function (radio) {
      if (radio.dataset.geisWired === '1') return;
    radio.dataset.geisWired = '1';
    radio.addEventListener('change', onShippingChange);
    if (isGeis(radio.value)) addIconIfNeeded(radio);
    });
  }

    ensureBaseStylesInjected();
    wireRadios(document);

    // dynamický refresh checkoutu
    var container = document.getElementById('checkout-shipping-method-load') || document.body;
    var mo = new MutationObserver(function () {ensureBaseStylesInjected(); wireRadios(container); });
    mo.observe(container, {childList: true, subtree: true });

});
