﻿$(function () {
  const orderId = $('input[name="OrderId"]').val();
  if (!orderId) return;

  // Najdi první kartu v AddShipment
  const firstCard = $('.cards-group .card.card-default').first();

  if (firstCard.length) {
    $.get('/Admin/PacketaShipment/_ShipmentConfigurationPacketa', { orderId: orderId })
      .done(function (html) {
        if (html && html.trim()) {
          $(html).insertAfter(firstCard);
        }
      })
      .fail(function (xhr, status, error) {
        console.error('Chyba při načítání konfigurace Packeta:', error);
      });
  }

  const form = $('form[action*="/Admin/Order/AddShipment"]');
  if (!form.length) {
    console.warn("Packeta plugin: Nelze najít formulář AddShipment.");
    return;
  }

  let isSubmitting = false;

  // Reakce na kliknutí na tlačítka uložení
  $("#shipment-save, #shipment-save-continue").on("click.packeta", function (e) {
    e.preventDefault();
    if (isSubmitting) return;

    const isPacketaShipment = form.find('input[name="IsPacketaShipment"]').val() === 'true';
    if (!isPacketaShipment) return;

    isSubmitting = true;

    const button = $(this);
    const actionName = button.attr("name");
    const token = $('input[name="__RequestVerificationToken"]').val();

    $.ajax({
      type: "POST",
      url: "/Admin/PacketaShipment/SavePacketaShipmentData",
      data: form.serialize(),
      contentType: "application/x-www-form-urlencoded; charset=UTF-8",
      headers: {
        "RequestVerificationToken": token
      },
      success: function (response) {
        if (response && response.success) {
          // Přidáme hidden input, aby se form submitnul nativně
          $("<input>")
            .attr("type", "hidden")
            .attr("name", actionName)
            .val("true")
            .appendTo(form);

          form[0].submit(); // Odeslání standardního formuláře
        } else {
          alert("Nepodařilo se uložit Packeta data.");
          isSubmitting = false;
        }
      },
      error: function () {
        alert("Chyba při komunikaci se serverem. Zkuste to prosím znovu.");
        isSubmitting = false;
      }
    });
  });
});
