﻿$(function () {
  const orderId = $('input[name="OrderId"]').val();
  if (!orderId) return;

  const firstCard = $('.cards-group .card.card-default').first();

  if (firstCard.length) {
    $.get('/Admin/PPLShipment/_ShipmentConfigurationPPL', { orderId: orderId })
      .done(function (html) {
        if (html && html.trim()) {
          $(html).insertAfter(firstCard);
        }
      })
      .fail(function (xhr, status, error) {
        console.error('Chyba při načítání PPL konfigurace:', error);
      });
  }

  const form = $('form[action*="/Admin/Order/AddShipment"]');
  if (!form.length) {
    console.warn("PPL plugin: nelze najít formulář AddShipment.");
    return;
  }

  let isSubmitting = false;

  $("#shipment-save, #shipment-save-continue").on("click.ppl", function (e) {
    e.preventDefault();
    if (isSubmitting) return;

    const isPPLShipment = form.find('input[name="IsPPLShipment"]').val() === 'true';
    if (!isPPLShipment) return;

    isSubmitting = true;

    const button = $(this);
    const actionName = button.attr("name");
    const token = $('input[name="__RequestVerificationToken"]').val();

    $.ajax({
      type: "POST",
      url: "/Admin/PPLShipment/SavePPLShipmentData",
      data: form.serialize(),
      contentType: "application/x-www-form-urlencoded; charset=UTF-8",
      headers: {
        "RequestVerificationToken": token
      },
      success: function (response) {
        if (response && response.success) {
          // Přidat hidden input s názvem tlačítka
          $("<input>")
            .attr("type", "hidden")
            .attr("name", actionName)
            .val("true")
            .appendTo(form);

          // Odeslat formulář nativně (neodstraňuj ostatní submit handlery!)
          form[0].submit();
        } else {
          alert("Nepodařilo se uložit PPL data.");
          isSubmitting = false;
        }
      },
      error: function () {
        alert("Chyba při komunikaci se serverem. Zkuste to prosím znovu.");
        isSubmitting = false;
      }
    });
  });
});
