﻿$(function () {
  const orderId = $('input[name="OrderId"]').val();
  if (!orderId) return;

  const firstCard = $('.cards-group .card.card-default').first();

  if (firstCard.length) {
    $.get('/Admin/GeisShipment/_ShipmentConfigurationGeis', { orderId: orderId })
      .done(function (html) {
        if (html && html.trim()) {
          $(html).insertAfter(firstCard);
        }
      })
      .fail(function (xhr, status, error) {
        console.error('Chyba při načítání Geis konfigurace:', error);
      });
  }

  const form = $('form[action*="/Admin/Order/AddShipment"]');
  if (!form.length) {
    console.warn("Geis plugin: nelze najít formulář AddShipment.");
    return;
  }

  let isSubmitting = false;

  $("#shipment-save, #shipment-save-continue").on("click.Geis", function (e) {
    e.preventDefault();
    if (isSubmitting) return;

    const isGeisShipment = form.find('input[name="IsGeisShipment"]').val() === 'true';
    if (!isGeisShipment) return;

    isSubmitting = true;

    const button = $(this);
    const actionName = button.attr("name");
    const token = $('input[name="__RequestVerificationToken"]').val();

    $.ajax({
      type: "POST",
      url: "/Admin/GeisShipment/SaveGeisShipmentData",
      data: form.serialize(),
      contentType: "application/x-www-form-urlencoded; charset=UTF-8",
      headers: {
        "RequestVerificationToken": token
      },
      success: function (response) {
        if (response && response.success) {
          // Přidat hidden input s názvem tlačítka
          $("<input>")
            .attr("type", "hidden")
            .attr("name", actionName)
            .val("true")
            .appendTo(form);

          // Odeslat formulář nativně (neodstraňuj ostatní submit handlery!)
          form[0].submit();
        } else {
          alert("Nepodařilo se uložit Geis data.");
          isSubmitting = false;
        }
      },
      error: function () {
        alert("Chyba při komunikaci se serverem. Zkuste to prosím znovu.");
        isSubmitting = false;
      }
    });
  });
});
