﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="xml" indent="yes" encoding="UTF-8"/>

  <xsl:template match="/">
    <Products>
      <xsl:apply-templates select="SHOP/SHOPITEM"/>
    </Products>
  </xsl:template>

  <!-- Každý produkt -->
  <xsl:template match="SHOPITEM">
    <Product>
      <Name>
        <xsl:value-of select="normalize-space(NAME)"/>
      </Name>
      <ShortDescription>
        <xsl:value-of select="normalize-space(SHORT_DESCRIPTION)"/>
      </ShortDescription>
      <FullDescription>
        <xsl:value-of select="normalize-space(DESCRIPTION)"/>
      </FullDescription>
      <Sku>
        <xsl:value-of select="CODE"/>
      </Sku>
      <Price>
        <xsl:value-of select="PRICE"/>
      </Price>
      <StockQuantity>
        <xsl:value-of select="STOCK/AMOUNT"/>
      </StockQuantity>
      <Category>
        <xsl:value-of select="DEFAULT_CATEGORY"/>
      </Category>
      <Manufacturer>
        <xsl:value-of select="MANUFACTURER"/>
      </Manufacturer>
      <Image>
        <xsl:value-of select="IMAGES/IMAGE[1]"/>
      </Image>
    </Product>
  </xsl:template>

</xsl:stylesheet>
