﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="xml" indent="yes" encoding="UTF-8"/>

  <!-- Root -->
  <xsl:template match="/">
    <Products>
      <xsl:apply-templates select="SHOP/SHOPITEM"/>
    </Products>
  </xsl:template>

  <!-- Každý produkt -->
  <xsl:template match="SHOPITEM">
    <Product>
      <Name>
        <xsl:value-of select="normalize-space(NAME)"/>
      </Name>
      <ShortDescription>
        <xsl:value-of select="normalize-space(SHORT_DESCRIPTION)"/>
      </ShortDescription>
      <FullDescription>
        <xsl:value-of select="normalize-space(DESCRIPTION)"/>
      </FullDescription>
      <Sku>
        <xsl:value-of select="CODE"/>
      </Sku>
      <SeName>
        <xsl:value-of select="URL"/>
      </SeName>
      <Price>
        <xsl:value-of select="PRICE"/>
      </Price>
      <StockQuantity>
        <xsl:value-of select="STOCK/AMOUNT"/>
      </StockQuantity>

      <!-- Kategorie -->
      <Categories>
        <xsl:for-each select="CATEGORIES/CATEGORY | CATEGORIES/DEFAULT_CATEGORY">
          <Category>
            <Id>
              <xsl:value-of select="@id"/>
            </Id>
            <Name>
              <xsl:value-of select="normalize-space(.)"/>
            </Name>
          </Category>
        </xsl:for-each>
      </Categories>

      <Manufacturer>
        <xsl:value-of select="MANUFACTURER"/>
      </Manufacturer>
      <EAN>
        <xsl:value-of select="EAN"/>
      </EAN>
      <Weight>
        <xsl:value-of select="WEIGHT"/>
      </Weight>
      <Dimensions>
        <xsl:value-of select="concat(LENGTH, 'x', WIDTH, 'x', HEIGHT)"/>
      </Dimensions>

      <!-- Obrázky -->
      <Images>
        <xsl:for-each select="IMAGES/IMAGE">
          <Image>
            <xsl:value-of select="."/>
          </Image>
        </xsl:for-each>
      </Images>
    </Product>
  </xsl:template>

</xsl:stylesheet>
