﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="xml" indent="yes" />

  <!-- Root element -->
  <xsl:template match="/CATEGORIES">
    <Categories>
      <xsl:apply-templates select="CATEGORY" />
    </Categories>
  </xsl:template>

  <!-- Transformace jedné kategorie -->
  <xsl:template match="CATEGORY">
    <Category>
      <Id>
        <xsl:value-of select="ID"/>
      </Id>
      <ParentId>
        <xsl:value-of select="PARENT_ID"/>
      </ParentId>
      <Name>
        <xsl:value-of select="TITLE"/>
      </Name>
      <SeName>
        <xsl:value-of select="INDEX_NAME"/>
      </SeName>
      <Description>
        <xsl:value-of select="concat(normalize-space(TOP_DESCRIPTION), ' ', normalize-space(BOTTOM_DESCRIPTION))"/>
      </Description>
      <MetaTitle>
        <xsl:value-of select="META_TITLE"/>
      </MetaTitle>
      <MetaDescription>
        <xsl:value-of select="META_DESCRIPTION"/>
      </MetaDescription>
      <Published>
        <xsl:choose>
          <xsl:when test="VISIBLE='1'">true</xsl:when>
          <xsl:otherwise>false</xsl:otherwise>
        </xsl:choose>
      </Published>
      <DisplayOrder>
        <xsl:value-of select="PRIORITY"/>
      </DisplayOrder>
    </Category>
  </xsl:template>

</xsl:stylesheet>
